--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNworldStatistics ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNgatherWorldInfo =
  (
    local LOCworldInfo = #(#(),#())
    local LOCotherInfo = #(0,0)

    if DYNworldStatistics.open == true then
    (
      DYNworldStatistics.dnWorld.items.clear()

      --- Count up Vertices and Faces for every object in the scene and put into various arrays
      local LOCnodeArray     = DYNFUNgetCivilViewCategorizedNodeArrays "nodes" false
      local LOClistItemRange = #() --array to collect the list items

      for i = 1 to DYNcivilViewCategoryCount do
      (
        append LOCworldInfo[1] 0
        append LOCworldInfo[2] 0

        for ii in LOCnodeArray[i] do
        (
          LOCworldInfo[1][i] += (getPolygonCount ii)[1]     -- Count Number of Faces
          LOCworldInfo[2][i] += (getPolygonCount ii)[2]     -- Count Number of Vertices
        )

        --- dOTnet vERSION
        local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesObjClasses[i] + " (" + (LOCnodeArray[i].count as string) + ")")
        local LOCsubItem  = LOClistItem.SubItems.add (LOCworldInfo[DYNworldStatistics.DDDYNlistType.selection][i] as string)
        LOClistItem.ImageIndex = i
        append LOClistItemRange LOClistItem --we add the list item to the array
      )

      for i = 16 to 20 do
      (
        for ii in LOCnodeArray[i] do
        (
          LOCotherInfo[1] += (getPolygonCount ii)[1]     -- Count Number of Faces
          LOCotherInfo[2] += (getPolygonCount ii)[2]     -- Count Number of Vertices
        )
      )

      --- Calculate Totals for VSP Objects
      local LOCvspTotal = 0
      local LOCinfoTotal = #(0,0)
      for i = 1 to DYNcivilViewCategoryCount do LOCvspTotal += LOCnodeArray[i].count
      for i = 1 to LOCworldInfo[1].count do LOCinfoTotal[1] += LOCworldInfo[1][i]
      for i = 1 to LOCworldInfo[2].count do LOCinfoTotal[2] += LOCworldInfo[2][i]

      --- Calculate Totals For Non-VSP Objects
      local LOCnonVspTotal = 0
      for i = 16 to 20 do LOCnonVspTotal += LOCnodeArray[i].count
      LOCinfoTotal[1] += LOCotherInfo[1] -- Add face totals for non-VSP objects
      LOCinfoTotal[2] += LOCotherInfo[2] -- Add vertex totals for non-VSP objects

      --- dOTnet vERSION
      local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[86] + " (" + (LOCnonVspTotal as string) + ")")
      local LOCsubItem  = LOClistItem.SubItems.add (LOCotherInfo[DYNworldStatistics.DDDYNlistType.selection] as string)
      LOClistItem.ImageIndex = 6
      append LOClistItemRange LOClistItem --we add the list item to the array

      --- Display Totals in Panel
      local LOClistItem = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesLabels[19] + " (" + ((LOCvspTotal + LOCnonVspTotal) as string) + ")")
      local LOCsubItem  = LOClistItem.SubItems.add (LOCinfoTotal[DYNworldStatistics.DDDYNlistType.selection] as string)
      LOClistItem.font  = DYNdnBoldFont
      LOClistItem.ImageIndex = 44
      append LOClistItemRange LOClistItem --we add the list item to the array

      --- Update dotNET ListView
      DYNworldStatistics.dnWorld.Items.AddRange LOClistItemRange --when done, we populate the ListView
      DYNworldStatistics.dnWorld.refresh()
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  dropdownlist DDDYNlistType align:#center width:(DYNiniExplorerWidth - 23)

  dotNetControl  dnWorld "System.Windows.Forms.ListView" height:350 width:(DYNiniExplorerWidth - 23) align:#center

  button BUDYNupdate   width:(DYNiniExplorerWidth - 21) align:#center
  button BUDYNadvanced width:(DYNiniExplorerWidth - 21) align:#center

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNworldStatistics open do
  (
    DYNworldStatistics.title   = DYNuiRolloutNames[1]
    DDDYNlistType.items        = #(DYNuiResourcesLvColumns[10], DYNuiResourcesLvColumns[11])
    DDDYNlistType.selection    = 1

    BUDYNupdate.text           = DYNuiResourcesButtons[29]
    BUDYNadvanced.text         = DYNuiResourcesButtons[28]

    --- Set Up dotNET List View Control
    DYNFUNdnListViewStyle dnWorld false true
    dnWorld.multiSelect        = false
    dnWorld.AllowColumnReorder = false
    dnWorld.sorting            = DYNdnSortOrderClass.none
    dnWorld.smallImageList     = DYNdnSmImageList
    local LOCcol1 = dnWorld.Columns.add DYNuiResourcesLvColumns[9] 120
    LOCcol1.textAlign = DYNdnHorAlignClass.left
    if DDDYNlistType.selection == 1 then  -- Faces
    (
      local LOCcol3 = dnWorld.Columns.add DYNuiResourcesLvColumns[10] 60
      LOCcol3.textAlign = DYNdnHorAlignClass.right
    )
    else
    (                                     -- Vertices
      local LOCcol3 = dnWorld.Columns.add DYNuiResourcesLvColumns[11] 60
      LOCcol3.textAlign = DYNdnHorAlignClass.right
    )

    DYNFUNgatherWorldInfo()
  )

  on DYNworldStatistics close do
  (
    dnWorld.Items.clear()
  )

  on DDDYNlistType selected arg do
  (
    if arg == 1 then dnWorld.columns.item[1].text = DYNuiResourcesLvColumns[10]
    if arg == 2 then dnWorld.columns.item[1].text = DYNuiResourcesLvColumns[11]
    DYNFUNgatherWorldInfo()
  )

  on BUDYNupdate   pressed do DYNFUNgatherWorldInfo()
  on BUDYNadvanced pressed do (max file summary)
)
